// To parse this JSON data, do
//
//     final countryInfoModel = countryInfoModelFromJson(jsonString);

import 'dart:convert';

CountryInfoModel countryInfoModelFromJson(String str) => CountryInfoModel.fromJson(json.decode(str));

String countryInfoModelToJson(CountryInfoModel data) => json.encode(data.toJson());

class CountryInfoModel {
    String? remark;
    String? status;
    Data? data;

    CountryInfoModel({
        this.remark,
        this.status,
        this.data,
    });

    factory CountryInfoModel.fromJson(Map<String, dynamic> json) => CountryInfoModel(
        remark: json["remark"],
        status: json["status"],
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
    );

    Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "data": data?.toJson(),
    };
}

class Data {
    List<SendingCountries>? sendingCountries;
    List<ReceivingCountries>? receivingCountries;

    Data({
        this.sendingCountries,
        this.receivingCountries,
    });

    factory Data.fromJson(Map<String, dynamic> json) => Data(
        sendingCountries: json["sending_countries"] == null ? [] : List<SendingCountries>.from(json["sending_countries"]!.map((x) => SendingCountries.fromJson(x))),
        receivingCountries: json["receiving_countries"] == null ? [] : List<ReceivingCountries>.from(json["receiving_countries"]!.map((x) => ReceivingCountries.fromJson(x))),
    );

    Map<String, dynamic> toJson() => {
        "sending_countries": sendingCountries == null ? [] : List<dynamic>.from(sendingCountries!.map((x) => x.toJson())),
        "receiving_countries": receivingCountries == null ? [] : List<dynamic>.from(receivingCountries!.map((x) => x.toJson())),
    };
}

class ReceivingCountries {
  ReceivingCountries({
      int? id, 
      String? name, 
      String? countryCode, 
      String? dialCode, 
      String? currency, 
      String? rate, 
      String? image, 
      String? isSending, 
      String? isReceiving, 
      String? hasAgent, 
      String? status, 
      String? createdAt, 
      String? updatedAt, 
      List<CountryDeliveryMethods>? countryDeliveryMethods,}){
    _id = id;
    _name = name;
    _countryCode = countryCode;
    _dialCode = dialCode;
    _currency = currency;
    _rate = rate;
    _image = image;
    _isSending = isSending;
    _isReceiving = isReceiving;
    _hasAgent = hasAgent;
    _status = status;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
    _countryDeliveryMethods = countryDeliveryMethods;
}

  ReceivingCountries.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'] != null ? json['name'].toString() : '';
    _countryCode = json['country_code'] != null ? json['country_code'].toString() : '';
    _dialCode = json['dial_code'] != null ? json['dial_code'].toString() : '';
    _currency = json['currency'] != null ? json['currency'].toString() : '';
    _rate = json['rate'] != null ? json['rate'].toString() : '';
    _image = json['image'];
    _isSending = json['is_sending'].toString();
    _isReceiving = json['is_receiving'].toString();
    _hasAgent = json['has_agent'].toString();
    _status = json['status'].toString();
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
    if (json['country_delivery_methods'] != null) {
      _countryDeliveryMethods = [];
      json['country_delivery_methods'].forEach((v) {
        _countryDeliveryMethods?.add(CountryDeliveryMethods.fromJson(v));
      });
    }
  }
  int? _id;
  String? _name;
  String? _countryCode;
  String? _dialCode;
  String? _currency;
  String? _rate;
  String? _image;
  String? _isSending;
  String? _isReceiving;
  String? _hasAgent;
  String? _status;
  String? _createdAt;
  String? _updatedAt;
  List<CountryDeliveryMethods>? _countryDeliveryMethods;

  int? get id => _id;
  String? get name => _name;
  String? get countryCode => _countryCode;
  String? get dialCode => _dialCode;
  String? get currency => _currency;
  String? get rate => _rate;
  String? get image => _image;
  String? get isSending => _isSending;
  String? get isReceiving => _isReceiving;
  String? get hasAgent => _hasAgent;
  String? get status => _status;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;
  List<CountryDeliveryMethods>? get countryDeliveryMethods => _countryDeliveryMethods;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['name'] = _name;
    map['country_code'] = _countryCode;
    map['dial_code'] = _dialCode;
    map['currency'] = _currency;
    map['rate'] = _rate;
    map['image'] = _image;
    map['is_sending'] = _isSending;
    map['is_receiving'] = _isReceiving;
    map['has_agent'] = _hasAgent;
    map['status'] = _status;
    map['created_at'] = _createdAt;
    map['updated_at'] = _updatedAt;
    if (_countryDeliveryMethods != null) {
      map['country_delivery_methods'] = _countryDeliveryMethods?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}
class CountryDeliveryMethods {
  CountryDeliveryMethods({
    int? id,
    String? countryId,
    String? deliveryMethodId,
    DeliveryMethod? deliveryMethod,
    Charge? charge,}){
    _id = id;
    _countryId = countryId;
    _deliveryMethodId = deliveryMethodId;
    _deliveryMethod = deliveryMethod;
    _charge = charge;
  }

  CountryDeliveryMethods.fromJson(dynamic json) {
    _id = json['id'];
    _countryId = json['country_id'] != null ? json['country_id'].toString() : '';
    _deliveryMethodId = json['delivery_method_id'] != null ? json['delivery_method_id'].toString() : '';
    _deliveryMethod = json['delivery_method'] != null ? DeliveryMethod.fromJson(json['delivery_method']) : null;
    _charge = json['charge'] != null ? Charge.fromJson(json['charge']) : null;
  }
  int? _id;
  String? _countryId;
  String? _deliveryMethodId;
  DeliveryMethod? _deliveryMethod;
  Charge? _charge;

  int? get id => _id;
  String? get countryId => _countryId;
  String? get deliveryMethodId => _deliveryMethodId;
  DeliveryMethod? get deliveryMethod => _deliveryMethod;
  Charge? get charge => _charge;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['country_id'] = _countryId;
    map['delivery_method_id'] = _deliveryMethodId;
    if (_deliveryMethod != null) {
      map['delivery_method'] = _deliveryMethod?.toJson();
    }
    if (_charge != null) {
      map['charge'] = _charge?.toJson();
    }
    return map;
  }

}


class SendingCountries {
  SendingCountries({
      int? id, 
      String? name, 
      String? countryCode, 
      String? dialCode, 
      String? currency, 
      String? rate, 
      String? image, 
      String? isSending, 
      String? isReceiving, 
      String? hasAgent, 
      String? status, 
      String? createdAt, 
      String? updatedAt, 
      List<ConversionRate>? conversionRates,}){
    _id = id;
    _name = name;
    _countryCode = countryCode;
    _dialCode = dialCode;
    _currency = currency;
    _rate = rate;
    _image = image;
    _isSending = isSending;
    _isReceiving = isReceiving;
    _hasAgent = hasAgent;
    _status = status;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
    _conversionRates = conversionRates;
}

  SendingCountries.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'];
    _countryCode = json['country_code'].toString();
    _dialCode = json['dial_code'].toString();
    _currency = json['currency'];
    _rate = json['rate'] != null? json['rate'].toString() : "";
    _image = json['image'];
    _isSending = json['is_sending'].toString();
    _isReceiving = json['is_receiving'].toString();
    _hasAgent = json['has_agent'].toString();
    _status = json['status'].toString();
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
    if (json['conversion_rates'] != null) {
      _conversionRates = [];
      json['conversion_rates'].forEach((v) {
        _conversionRates?.add(ConversionRate.fromJson(v));
      });
    }
  }
  
  int? _id;
  String? _name;
  String? _countryCode;
  String? _dialCode;
  String? _currency;
  String? _rate;
  String? _image;
  String? _isSending;
  String? _isReceiving;
  String? _hasAgent;
  String? _status;
  String? _createdAt;
  String? _updatedAt;
  List<ConversionRate>? _conversionRates;

  int? get id => _id;
  String? get name => _name;
  String? get countryCode => _countryCode;
  String? get dialCode => _dialCode;
  String? get currency => _currency;
  String? get rate => _rate;
  String? get image => _image;
  String? get isSending => _isSending;
  String? get isReceiving => _isReceiving;
  String? get hasAgent => _hasAgent;
  String? get status => _status;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;
  List<ConversionRate>? get conversionRates => _conversionRates;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['name'] = _name;
    map['country_code'] = _countryCode;
    map['dial_code'] = _dialCode;
    map['currency'] = _currency;
    map['rate'] = _rate;
    map['image'] = _image;
    map['is_sending'] = _isSending;
    map['is_receiving'] = _isReceiving;
    map['has_agent'] = _hasAgent;
    map['status'] = _status;
    map['created_at'] = _createdAt;
    map['updated_at'] = _updatedAt;
    if (_conversionRates != null) {
      map['conversion_rates'] = _conversionRates?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}
class ConversionRate {
    int? id;
    String? fromCountry;
    String? toCountry;
    String? rate;
    String? createdAt;
    String? updatedAt;

    ConversionRate({
        this.id,
        this.fromCountry,
        this.toCountry,
        this.rate,
        this.createdAt,
        this.updatedAt,
    });

    factory ConversionRate.fromJson(Map<String, dynamic> json) => ConversionRate(
        id: json["id"],
        fromCountry: json["from_country"].toString(),
        toCountry: json["to_country"].toString(),
        rate: json["rate"].toString(),
        createdAt: json["created_at"].toString() ,
        updatedAt: json["updated_at"].toString(),
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "from_country": fromCountry,
        "to_country": toCountry,
        "rate": rate,
        "created_at": createdAt,
        "updated_at": updatedAt,
    };
}

class CountryDeliveryMethod {
    int? id;
    int? countryId;
    int? deliveryMethodId;
    DeliveryMethod? deliveryMethod;
    Charge? charge;

    CountryDeliveryMethod({
        this.id,
        this.countryId,
        this.deliveryMethodId,
        this.deliveryMethod,
        this.charge,
    });

    factory CountryDeliveryMethod.fromJson(Map<String, dynamic> json) => CountryDeliveryMethod(
        id: json["id"],
        countryId: json["country_id"],
        deliveryMethodId: json["delivery_method_id"],
        deliveryMethod: json["delivery_method"] == null ? null : DeliveryMethod.fromJson(json["delivery_method"]),
        charge: json["charge"] == null ? null : Charge.fromJson(json["charge"]),
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "country_id": countryId,
        "delivery_method_id": deliveryMethodId,
        "delivery_method": deliveryMethod?.toJson(),
        "charge": charge?.toJson(),
    };
}

class Charge {
    int? countryDeliveryMethodId;
    String? fixedCharge;
    String? percentCharge;

    Charge({
        this.countryDeliveryMethodId,
        this.fixedCharge,
        this.percentCharge,
    });

    factory Charge.fromJson(Map<String, dynamic> json) => Charge(
        countryDeliveryMethodId: json["country_delivery_method_id"],
        fixedCharge: json["fixed_charge"],
        percentCharge: json["percent_charge"],
    );

    Map<String, dynamic> toJson() => {
        "country_delivery_method_id": countryDeliveryMethodId,
        "fixed_charge": fixedCharge,
        "percent_charge": percentCharge,
    };
}

class DeliveryMethod {
    int? id;
    String? name;

    DeliveryMethod({
        this.id,
        this.name,
    });

    factory DeliveryMethod.fromJson(Map<String, dynamic> json) => DeliveryMethod(
        id: json["id"],
        name: json["name"],
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
    };
}
